//admin
var loader     = '<div class="d-flex"><div class="spinner-border text-danger" role="status"><span class="visually-hidden">Loading...</span></div></div>';
var loaderSm   = '<div class="d-flex"><div class="spinner-border spinner-border-sm text-danger" role="status"><span class="visually-hidden">Loading...</span></div></div>';
var whLoader   = '<div class="d-flex"><div class="spinner-border spinner-border-sm text-light" role="status"><span class="visually-hidden">Loading...</span></div></div>';
var whLoaderLg = '<div class="d-flex"><div class="spinner-border text-light" role="status"><span class="visually-hidden">Loading...</span></div></div>';

//pp
var dzNew = {
    init: function() {
        this.on('addedfile', function(file, response) {
            $('#addImages').hide();
        });
        this.on("sendingmultiple", function(file, xhr, formData) {
            formData.append('title', $('#publicProjectTitle').val());
            formData.append('description', $('#publicProjectDescription').val());
            formData.append('projectId', $('#publicProjectProjectId').val());
            formData.append('status', $('#publicProjectStatus').val());
            formData.append('city', $('#publicProjectCity').val());
            formData.append('value', $('#publicProjectValue').val());
            formData.append('type', $('#publicProjectType').val());
            formData.append('fromdz', 1);
        });
        this.on('successmultiple', function(file, response) {
            // console.log(response);
            this.removeAllFiles();
            $('#addImages').show();
            // toastr["success"]("Your post was created successfully. Please allow up to 60 seconds for the post to be visible in the portal.", "Post created successfully")
        });
        this.on('errormultiple', function(file, message) {
            // console.log(message);
            // toastr["error"](message, "Error");
        });
        this.on('reset', function() {
            $('#addImages').show();
        });
        this.on('complete', function() {
            location.reload(true);
        });
    },
    paramName: 'file',
    url: "/clients/admin/src/new-public-project.php",
    autoProcessQueue: false,
    uploadMultiple: true,
    acceptedFiles: 'image/jpeg,image/png',
    parallelUploads: 100,
    maxFilesize: 30,
    maxFiles: 100,
    previewTemplate: '<div class="dz-preview dz-file-preview text-center me-2"><div class="dz-details"><img data-dz-thumbnail /></div><div class="dz-progress"><span class="dz-upload" data-dz-uploadprogress></span></div><div class="dz-error-message"><span data-dz-errormessage></span></div><a class="text-danger" href="javascript:undefined;" data-dz-remove>Remove</a></div>',
};
//pp
var dzEdit = {
    init: function() {
        this.on('addedfile', function(file, response) {
            $('#addEditImages').hide();
        });
        this.on("sendingmultiple", function(file, xhr, formData) {
            formData.append('publicProjectId', $('#editPublicProjectId').val());
            formData.append('title', $('#editPublicProjectTitle').val());
            formData.append('description', $('#editPublicProjectDescription').val());
            formData.append('projectId', $('#editPublicProjectProjectId').val());
            formData.append('status', $('#editPublicProjectStatus').val());
            formData.append('city', $('#editPublicProjectCity').val());
            formData.append('value', $('#editPublicProjectValue').val());
            formData.append('type', $('#editPublicProjectType').val());
            formData.append('fromdz', 1);
        });
        this.on('successmultiple', function(file, response) {
            // console.log(response);
            this.removeAllFiles();
            $('#addEditImages').show();
            // toastr["success"]("Your post was created successfully. Please allow up to 60 seconds for the post to be visible in the portal.", "Post created successfully")
        });
        this.on('errormultiple', function(file, message) {
            // console.log(message);
            // toastr["error"](message, "Error");
        });
        this.on('reset', function() {
            $('#addEditImages').show();
        });
        this.on('complete', function() {
            location.reload(true);
        });
    },
    paramName: 'file',
    url: "/clients/admin/src/edit-public-project.php",
    autoProcessQueue: false,
    uploadMultiple: true,
    acceptedFiles: 'image/jpeg,image/png',
    parallelUploads: 100,
    maxFilesize: 30,
    maxFiles: 100,
    previewTemplate: '<div class="dz-preview dz-file-preview text-center me-2"><div class="dz-details"><img data-dz-thumbnail /></div><div class="dz-progress"><span class="dz-upload" data-dz-uploadprogress></span></div><div class="dz-error-message"><span data-dz-errormessage></span></div><a class="text-danger" href="javascript:undefined;" data-dz-remove>Remove</a></div>',
}
//p
var dzSelections = {
    init: function() {
        let selectionResultHtml = $('#selectionResultArea').html();

        this.on('addedfile', function(file, response) {
            $('#addPlans').hide();
            let ext = file.name.split('.').pop();
            if ( ext == 'pdf' || ext == 'PDF' ) {
                $(file.previewElement).find(".dz-details img").attr("src", "/clients/assets/images/pdf-icon.png").css('width', '120px').css('height', '120px');
            }
        });
        this.on("sending", function(file, xhr, formData) {
            $('#selectionResultArea').html(loader);
            formData.append('projectId', $('#newSelectionSheetProjectId').val());
        });
        this.on('success', function(file, response) {
            console.log(response);
            this.removeAllFiles();
            $('#addPlans').show();
            // toastr["success"]("File uploaded", "Success");

            $('#selectionResultArea').html(response);
        });
        this.on('error', function(file, message) {
            // console.log(message);
            // toastr["error"](message, "Error");
            $('#selectionResultArea').html(selectionResultHtml);
        });
        this.on('reset', function() {
            $('#addPlans').show();
        });
    }, 
    url: "/clients/admin/ajax/new-selection-sheet.php",
    // addRemoveLinks: true,
    autoProcessQueue: true,
    uploadMultiple: false,
    acceptedFiles: 'application/pdf',
    parallelUploads: 1,
    maxFilesize: 30,
    maxFiles: 1,
    previewTemplate: '<div class="dz-preview dz-file-preview text-center me-2"><div class="dz-details"><img data-dz-thumbnail /></div><div class="dz-filename"><span data-dz-name></span></div><div class="dz-progress"><span class="dz-upload" data-dz-uploadprogress></span></div><div class="dz-error-message"><span data-dz-errormessage></span></div><a class="text-danger" href="javascript:undefined;" data-dz-remove>Remove</a></div>',
}
//pp
function initNewDropzone() {
    return new Dropzone("div#publicProjectDropzone", dzNew);
}
//pp
function initEditDropzone() {
    return new Dropzone("div#editPublicProjectDropzone", dzEdit);
}
//p
function initSelectionsDropzone() {
    return new Dropzone("div#selectionsDropzone", dzSelections);
}

$(document).ready(function() {
    //admin
    $(document).on('click', '.editUserButton', function(e) {
        $('#editUserModalBody').html(loader);

        var id = $(this).data('id');
    
        $.ajax({
            url: '/clients/admin/ajax/edit-user-form.php',
            method: 'POST',
            dataType: 'html',
            data: {
                id: id
            },
            success: function (data) {
                // console.log(data);
                $('#editUserModalBody').html(data);
                $('.selectpicker').selectpicker();
            },
            error: function (e) {
                // var error = e.responseJSON.error;
                // console.log(error);
            }
        });
    });

    //admin
    $(document).on('click', '.editClientButton', function(e) {
        $('#editClientModalBody').html(loader);

        var id = $(this).data('id');
    
        $.ajax({
            url: '/clients/admin/ajax/edit-client-form.php',
            method: 'POST',
            dataType: 'html',
            data: {
                id: id
            },
            success: function (data) {
                // console.log(data);
                $('#editClientModalBody').html(data);
                $('.selectpicker').selectpicker();
            },
            error: function (e) {
                // var error = e.responseJSON.error;
                // console.log(error);
            }
        });
    });

    //admin maybe p
    $(document).on('click', '.editProjectButton', function(e) {
        $('#editProjectModalBody').html(loader);

        var id = $(this).data('id');
    
        $.ajax({
            url: '/clients/admin/ajax/edit-project-form.php',
            method: 'POST',
            dataType: 'html',
            data: {
                id: id
            },
            success: function (data) {
                // console.log(data);
                $('#editProjectModalBody').html(data);
                $('.selectpicker').selectpicker();

                $.ajax({
                    url: '/clients/admin/ajax/fetch-task-lists.php',
                    method: 'POST',
                    success: function (data) {
                        // console.log(data);
                        $('#editProjectTaskListSelect').html(data);
                        $('#editProjectTaskListLoader').html('<i class="bi bi-check text-success"></i>');

                        let sheetId = $('#editProjectTaskListSelect').data('id');
                        if ( sheetId ) {
                            $('#editProjectTaskListSelect').val(sheetId);
                        }
                    },
                    error: function (e) {
                    }
                });
            },
            error: function (e) {
                // var error = e.responseJSON.error;
                // console.log(error);
            }
        });
    });

    //c
    $(document).on('click', '.sendTokenButton', function(e) {
        $('#sendTokenModalBody').html(loader);

        var id = $(this).data('id');
    
        $.ajax({
            url: '/clients/admin/ajax/send-token-form.php',
            method: 'POST',
            dataType: 'html',
            data: {
                id: id
            },
            success: function (data) {
                // console.log(data);
                $('#sendTokenModalBody').html(data);
                $('.selectpicker').selectpicker();
            },
            error: function (e) {
                // var error = e.responseJSON.error;
                // console.log(error);
            }
        });
    });

    //
    $(document).on('change', '#addClientProject', function(e) {
        if ( $(this).is(':checked') ) {
            $('#clientProject').removeClass('d-none');
        } else {
            $('#clientProject').addClass('d-none');
        }
    });

    //
    $(document).on('change', '#addProjectClient', function(e) {
        if ( $(this).is(':checked') ) {
            $('#projectClient').removeClass('d-none');
        } else {
            $('#projectClient').addClass('d-none');
        }
    });

    //c
    $(document).on('click', '.viewClientLogsButton', function(e) {
        $('#clientLogsModalBody').html(loader);

        var id = $(this).data('id');
    
        $.ajax({
            url: '/clients/admin/ajax/view-client-logs.php',
            method: 'POST',
            dataType: 'html',
            data: {
                id: id
            },
            success: function (data) {
                // console.log(data);
                $('#clientLogsModalBody').html(data);
            },
            error: function (e) {
                // var error = e.responseJSON.error;
                // console.log(error);
            }
        });
    });

    //u
    $(document).on('click', '.viewUserLogsButton', function(e) {
        $('#userLogsModalBody').html(loader);

        var id = $(this).data('id');
    
        $.ajax({
            url: '/clients/admin/ajax/view-user-logs.php',
            method: 'POST',
            dataType: 'html',
            data: {
                id: id
            },
            success: function (data) {
                // console.log(data);
                $('#userLogsModalBody').html(data);
            },
            error: function (e) {
                // var error = e.responseJSON.error;
                // console.log(error);
            }
        });
    });

    //wh
    $(document).on('click', '#refreshWebhooksButton', function(e) {
        $('#webhooksTableLoader').html(whLoader);
        $.ajax({
            url: '/clients/admin/ajax/fetch-webhooks.php',
            method: 'POST',
            data: {},
            success: function (data) {
                // console.log(data);
                // $('#webhooksTableLoader').html('<i class="bi bi-arrow-repeat"></i>');
                $('#webhooksTableContainer').html(data);
                new DataTable('#webhooksDT', {
                    // dom: '<"d-flex justify-content-between my-2"<"d-flex me-auto"l><"d-flex ms-auto"f>>',
                    layout: {
                        topStart: {
                            pageLength: {
                                menu: [10, 25, 50, 100],
                                text: '_MENU_'
                            }
                        },
                        topEnd: {
                            search: {
                                text: '',
                                placeholder: 'Search'
                            }
                        },
                        bottomStart: null
                    },
                    pageLength: 50
                });
            },
            error: function (e) {
            }
        });
    });

    //pp
    $(document).on('click', '.editPublicProjectShareButton', function(e) {
        $('#editPublicProjectShareModalBody').html(loader);

        var id = $(this).data('id');
    
        $.ajax({
            url: '/clients/admin/ajax/edit-public-project-share-form.php',
            method: 'POST',
            dataType: 'html',
            data: {
                id: id
            },
            success: function (data) {
                // console.log(data);
                $('#editPublicProjectShareModalBody').html(data);
                $('.selectpicker').selectpicker();
            },
            error: function (e) {
                // var error = e.responseJSON.error;
                // console.log(error);
            }
        });
    });

    //pp
    $(document).on('change', '#publicProjectsCheckAll', function(e) {
        if ( $(this).is(':checked') ) {
            $('.publicProjectsCheck').prop('checked', true);
        } else {
            $('.publicProjectsCheck').prop('checked', false);
        }
    });

    //pp
    $(document).on('change', '.publicProjectsCheck', function(e) {
        if ( $(this).is(':checked') ) {
            //show buttons
        } else {
            //hide buttons
        }
    });
    
    //pp
    $(document).on('submit', '#newPublicProjectForm', function(e) {
        $('#newPublicProjectSubmit').prop('disabled', true);
        $('#newPublicProjectModalFooter').html(loader);
        if ( dz.files.length > 0 ) {
            e.preventDefault();
            e.stopPropagation();
            dz.processQueue();
        } else {
            $('#newPublicProjectForm').submit();
        }
    });

    //pp
    $(document).on('click', '.editPublicProjectButton', function(e) {
        $('#editPublicProjectModalBody').html(loader);

        var id = $(this).data('id');
    
        $.ajax({
            url: '/clients/admin/ajax/edit-public-project-form.php',
            method: 'POST',
            dataType: 'html',
            data: {
                id: id
            },
            success: function(data) {
                // console.log(data);
                $('#editPublicProjectModalBody').html(data);
                initObserver();
                initEditDropzone();
                Sortable.create(document.getElementById('editPublicProjectDragContainer'), {
                    delay: 100,
                    delayOnTouchOnly: true,
                    onEnd: function(evt) {
                        let order = [];
                        $('.editPublicProjectDragItem').each(function(i, e) {
                            order.push({"id": $(e).data('id'), "order": i});
                        });
                        console.log(order);

                        $.ajax({
                            url: '/clients/admin/ajax/order-public-project-attachments.php',
                            method: 'POST',
                            data: {
                                id: $('#editPublicProjectId').val(),
                                order: order
                            },
                            success: function(data) {
                                // console.log(data);
                            },
                            error: function (e) {
                            }
                        });
                    },
                });
            },
            error: function (e) {
                // var error = e.responseJSON.error;
                // console.log(error);
            }
        });
    });

    //pp
    $(document).on('submit', '#editPublicProjectForm', function(e) {
        let dze = Dropzone.forElement("#editPublicProjectDropzone");

        $('#editPublicProjectSubmit').prop('disabled', true);
        $('#editPublicProjectModalFooter').html(loader);
        if ( dze.files.length > 0 ) {
            e.preventDefault();
            e.stopPropagation();
            dze.processQueue();
        } else {
            $('#editPublicProjectForm').submit();
        }
    });

    //pp
    $(document).on('click', '.deletePublicProjectAttachment', function(e) {
        let col = $(this).closest('.publicProjectAttachmentCol');
        if ( window.confirm("Are you sure you want to remove this image from the public project?") == true ) {
            $.ajax({
                url: '/clients/admin/ajax/delete-public-project-attachment.php',
                method: 'POST',
                data: {
                    id: $(this).data('id')
                },
                success: function(data) {
                    // console.log(data);
                    // $(this).closest('.publicProjectAttachmentCol').remove();
                    col.remove();
                },
                error: function (e) {
                    // var error = e.responseJSON.error;
                    // console.log(error);
                }
            });
        }
    });

    //pp
    $(document).on('click', '.sharePublicProjectButton', function(e) {
        let id = $(this).data('id');
        $('#newPublicProjectShareSelect').selectpicker('val', id.toString());
    });

    //pp
    $(document).on('click', '.viewShareLogsButton', function(e) {
        $('#shareLogsModalBody').html(loader);

        var id = $(this).data('id');
    
        $.ajax({
            url: '/clients/admin/ajax/view-share-logs.php',
            method: 'POST',
            dataType: 'html',
            data: {
                id: id
            },
            success: function (data) {
                // console.log(data);
                $('#shareLogsModalBody').html(data);
            },
            error: function (e) {
                // var error = e.responseJSON.error;
                // console.log(error);
            }
        });
    });

    //ai
    $(document).on('submit', '#aiConversation', function(e) {
        e.preventDefault();

        let prompt = $('#prompt').val().trim();
        if ( !prompt.length ) {
            return;
        }

        // let conversationId = $('#conversationId').val();
        let form = $('#aiConversation')[0];
        let formData = new FormData(form);

        $('#systemPrompt').prop('disabled', true);
        $('#systemPrompt').removeClass('bg-light-subtle');
        $('#systemPrompt').addClass('bg-body');

        $('#prompt').prop('disabled', true);
        $('#aiSendMessage').prop('disabled', true);
        $('#aiSendMessage').html(loaderSm);

        $.ajax({
            url: '/clients/admin/ajax/send-ai-message.php',
            type: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            success: function (data) {
                // console.log(data);

                let response = JSON.parse(data);
                let conversationId = response.conversationId;
                let optionText = response.optionText;
                let html = response.html;
                let conversationTokens = response.conversationTokens;
                console.log(response.raw);

                if ( window.history.pushState ) {
                    let url = new URL(window.location.href);
                    url.search = '?page=ai&conversationId=' + conversationId;
                    window.history.replaceState({ path: url.href }, '', url.href);
                }

                $('#conversationId').val(conversationId);
                if ( !$('#selectConversationId').val() ) {
                    $('#selectConversationId option:first-child').after($('<option>', { value: conversationId, text: optionText }));
                    $('#selectConversationId').val(conversationId);
                }
                if ( $('#newConversationWrapper').length ) {
                    $('#response').html(html);
                } else {
                    $('#response').append(html);
                }
                $('#conversationTokens').text(conversationTokens);
                let id = $('.AIResponse').last().attr('id');
                document.getElementById(id).scrollIntoView({block: 'start'});

                $('#prompt').val('');
                $('#prompt').prop('disabled', false);
                $('#prompt').attr('placeholder', 'Continue your conversation...');

                $('#files').val('');
                $('#files').change();

                $('#aiSendMessage').prop('disabled', false);
                $('#aiSendMessage').html('<i class="bi bi-send"></i>');

                // $('#aiCopyPrompt').find('i').removeClass('text-danger');
                // $('#aiClearPrompt').find('i').removeClass('text-danger');

                const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]')
                const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl))

                initObserver();
            },
            error: function (e) {
                console.log(e);

                $('#prompt').prop('disabled', false);

                $('#aiSendMessage').prop('disabled', false);
                $('#aiSendMessage').html('<i class="bi bi-send"></i>');

                // $('#aiCopyPrompt').find('i').removeClass('text-danger');
                // $('#aiClearPrompt').find('i').removeClass('text-danger');
            }
        });
    });

    //ai
    $("#prompt").keypress(function(e) {
        if ( e.which === 13 && !e.shiftKey ) {
            e.preventDefault();
            $("#aiConversation").submit();
        }
    });

    //ai
    $("#prompt").keyup(function(e) {
        if ( $(this).val().trim() ) {
            $('#aiSendMessage').find('i').addClass('text-danger');
            // $('#aiCopyPrompt').find('i').addClass('text-danger');
            // $('#aiClearPrompt').find('i').addClass('text-danger');
        } else {
            $('#aiSendMessage').find('i').removeClass('text-danger');
            // $('#aiCopyPrompt').find('i').removeClass('text-danger');
            // $('#aiClearPrompt').find('i').removeClass('text-danger');
        }
    });

    //ai
    $("#aiClearPrompt").click(function(e) {
        $("#prompt").val('');
        $('#aiSendMessage').find('i').removeClass('text-danger');
        // $('#aiCopyPrompt').find('i').removeClass('text-danger');
        // $('#aiClearPrompt').find('i').removeClass('text-danger');
    });

    //ai
    $('#selectConversationId').on('change', function(e) {
        if ( this.value ) {
            window.location = 'https://bigtimberbuilders.com/clients/admin/?page=ai&conversationId='+this.value;
        } else {
            window.location = 'https://bigtimberbuilders.com/clients/admin/?page=ai';
        }
    });

    //ai
    $(document).on('change', '#files', function(e) {
        let files = document.getElementById('files').files;
        let string = '';
        if ( files.length ) {
            for ( let i = 0; i < files.length; i++ ) {
                let comma = ( (i + 1) === files.length )
                    ? ''
                    : ', '
                ;
                string += files[i].name + comma;
            }
            $('#aiAttachment').find('i').remove();
            $('#aiAttachment').prepend('<i class="bi bi-x text-danger"></i>');
            $('#selectedFiles').text(string);
        } else {
            $('#selectedFiles').text('');
            $('#aiAttachment').find('i').remove();
            $('#aiAttachment').prepend('<i class="bi bi-paperclip"></i>');
        }
    });

    //ai
    $(document).on('click', '#aiAttachment', function(e) {
        let files = document.getElementById('files').files;
        if ( files.length ) {
            e.preventDefault();

            $('#files').val('');
            $('#selectedFiles').html('');
            $('#aiAttachment').find('i').remove();
            $('#aiAttachment').prepend('<i class="bi bi-paperclip"></i>');
        }
    });

    //ai
    $('#prompt').on('focus', function(e) {
		autosize(this);
	});
	$('#prompt').on('blur', function(e) {
		let h = this.offsetHeight;
		autosize.destroy(this);

		this.style.height       = h + 'px';
		this.style.overflow     = 'hidden';
		this.style.overflow     = 'hidden';
		this.style.overflowWrap = 'break-word';
		this.style.textAlign    = 'start';
	});
    $('#prompt').on('autosize:resized', function(e) {
        let h = document.getElementById('promptRow').offsetHeight;
        $('#conversationTokensContainer').css('padding-bottom', h + 'px');
    });

    //ai
    $('#systemPrompt').on('focus', function(e) {
		autosize(this);
	});
	$('#systemPrompt').on('blur', function(e) {
		let h = this.offsetHeight;
		autosize.destroy(this);

		this.style.height       = h + 'px';
		this.style.overflow     = 'hidden';
		this.style.overflow     = 'hidden';
		this.style.overflowWrap = 'break-word';
		this.style.textAlign    = 'start';
	});

    //p
    $(document).on('click', '.newSelectionSheetButton', function(e) {
        var id = $(this).data('id');
        $('#newSelectionSheetProjectId').val(id);
    });

    //ai
    var aiClipboard = new ClipboardJS('.aiCopyResponse');
    aiClipboard.on('success', function(e) {
        $(e.trigger).html('<i class="bi bi-check text-success"></i>');
        setTimeout(function() {
            $(e.trigger).html('<i class="bi bi-copy"></i>');
        }, 2000);
    });

    //u
    new DataTable('#usersDT', {
        // dom: '<"d-flex justify-content-between my-2"<"d-flex me-auto"l><"d-flex ms-auto"f>>',
        layout: {
            topStart: {
                pageLength: {
                    menu: [10, 25, 50, 100],
                    text: '_MENU_'
                }
            },
            topEnd: {
                search: {
                    text: '',
                    placeholder: 'Search'
                }
            },
            bottomStart: null
        },
        pageLength: 50,
        // scrollX: true,
        // fixedColumns: true,
        // order: [[2, 'asc']]
    });

    //c
    new DataTable('#clientsDT', {
        // dom: '<"d-flex justify-content-between my-2"<"d-flex me-auto"l><"d-flex ms-auto"f>>',
        layout: {
            topStart: {
                pageLength: {
                    menu: [10, 25, 50, 100],
                    text: '_MENU_'
                }
            },
            topEnd: {
                search: {
                    text: '',
                    placeholder: 'Search'
                }
            },
            bottomStart: null
        },
        pageLength: 50,
        // scrollX: true,
        // fixedColumns: true,
        // order: [[2, 'asc']]
    });

    //p
    new DataTable('#projectsDT', {
        // dom: '<"d-flex justify-content-between my-2"<"d-flex me-auto"l><"d-flex ms-auto"f>>',
        layout: {
            topStart: {
                pageLength: {
                    menu: [10, 25, 50, 100],
                    text: '_MENU_'
                }
            },
            topEnd: {
                search: {
                    text: '',
                    placeholder: 'Search'
                }
            },
            bottomStart: null
        },
        pageLength: 50,
        // scrollX: true,
        // fixedColumns: true,
        // order: [[2, 'asc']]
    });

    //wh
    new DataTable('#webhooksDT', {
        // dom: '<"d-flex justify-content-between my-2"<"d-flex me-auto"l><"d-flex ms-auto"f>>',
        layout: {
            topStart: {
                pageLength: {
                    menu: [10, 25, 50, 100],
                    text: '_MENU_'
                }
            },
            topEnd: {
                search: {
                    text: '',
                    placeholder: 'Search'
                }
            },
            bottomStart: null
        },
        pageLength: 50
    });

    //pp
    var ppTable = new DataTable('#publicProjectsDT', {
        // dom: '<"d-flex justify-content-between my-2"<"d-flex me-auto"l><"d-flex ms-auto"f>>',
        layout: {
            topStart: {
                pageLength: {
                    menu: [10, 25, 50, 100],
                    text: '_MENU_'
                }
            },
            topEnd: {
                search: {
                    text: '',
                    placeholder: 'Search'
                }
            },
            bottomStart: null
        },
        columns: [
            // {
            //     name: 'zeroth',
            //     className: 'dt-control',
            //     orderable: false,
            //     data: null,
            //     defaultContent: '',
            //     target: 0
            // },
            // {name: 'first', orderable: false},
            {name: 'second', orderable: true},
            {name: 'third', orderable: true},
            {name: 'fourth', orderable: true},
            {name: 'fifth', orderable: true},
            {name: 'sixth', orderable: true},
            {name: 'seventh', orderable: true},
            {name: 'eighth', orderable: true},
            {name: 'ninth', orderable: true},
            {name: 'tenth', orderable: false},
            // {name: 'eleventh', orderable: false, visible: false, targets: 10},
        ],
        pageLength: 100,
        // scrollX: true,
        // fixedColumns: true,
        order: [[0, 'asc']]
    });
    new DataTable('#publicProjectsShareDT', {
        // dom: '<"d-flex justify-content-between my-2"<"d-flex me-auto"l><"d-flex ms-auto"f>>',
        layout: {
            topStart: {
                pageLength: {
                    menu: [10, 25, 50, 100],
                    text: '_MENU_'
                }
            },
            topEnd: {
                search: {
                    text: '',
                    placeholder: 'Search'
                }
            },
            bottomStart: null
        },
        pageLength: 50
    });

    //admin
    const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]')
    const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl))

    //pp
    var clipboard = new ClipboardJS('.copyPublicProjectShareLink');
    clipboard.on('success', function(e) {
        $(e.trigger).html('<i class="bi bi-check"></i>');
        setTimeout(function() {
            $(e.trigger).html('<i class="bi bi-copy"></i>');
        }, 2000);
    });

    //admin
    $('.selectpicker').selectpicker();

    //pp
    const dz = initNewDropzone();

    //p
    const selectionsDz = initSelectionsDropzone();

    //pp
    Fancybox.bind("[data-fancybox]", {
		Toolbar: {
			display: {
				left: ["infobar"],
				middle: [],
				right: ["iterateZoom", "slideshow", "thumbs", "close"],
			},
		},
	});

    //ai
    if ( $('#prompt').length ) {
        let h = document.getElementById('promptRow').offsetHeight;
        $('#conversationTokensContainer').css('padding-bottom', h + 'px');
    }
});